/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.diagnosis.local.impl.serialization.java;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPOutputStream;
import net.jcores.CoreKeeper;
import net.xeoh.plugins.diagnosis.local.impl.serialization.java.Entry;

public class LogFileWriter {
    FileOutputStream fileOutputStream;
    ObjectOutputStream objectOutputStream;
    GZIPOutputStream zipStream;
    LinkedBlockingQueue<Entry> eventQueue = new LinkedBlockingQueue();

    public LogFileWriter(String file, boolean compressOutput) {
        try {
            CoreKeeper.$(file).file().delete();
            this.fileOutputStream = new FileOutputStream(CoreKeeper.$(file).get("diagnosis.fallback.record"));
            if (compressOutput) {
                this.zipStream = new GZIPOutputStream(this.fileOutputStream);
                this.objectOutputStream = new ObjectOutputStream(this.zipStream);
            } else {
                this.objectOutputStream = new ObjectOutputStream(this.fileOutputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int flushCount = 0;
                while (true) {
                    try {
                        while (true) {
                            Entry take = LogFileWriter.this.eventQueue.take();
                            LogFileWriter.this.objectOutputStream.writeUnshared(take);
                            if (flushCount++ <= 50) continue;
                            LogFileWriter.this.objectOutputStream.reset();
                            LogFileWriter.this.objectOutputStream.flush();
                            if (LogFileWriter.this.zipStream != null) {
                                LogFileWriter.this.zipStream.flush();
                            }
                            LogFileWriter.this.fileOutputStream.flush();
                            flushCount = 0;
                        }
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setName("LogFileWriter.serializer");
        thread.setDaemon(true);
        thread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                LogFileWriter.this.terminate();
            }
        }));
    }

    void terminate() {
        try {
            this.objectOutputStream.flush();
            if (this.zipStream != null) {
                this.zipStream.flush();
            }
            this.fileOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void record(Entry entry) {
        this.eventQueue.add(entry);
    }
}

