/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.diagnosis.local.impl.serialization.java;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import net.jcores.CoreKeeper;
import net.xeoh.plugins.diagnosis.local.impl.serialization.java.Entry;
import net.xeoh.plugins.diagnosis.local.impl.serialization.java.EntryCallback;

public class LogFileReader {
    private final String file;

    public LogFileReader(String file) {
        this.file = file;
    }

    public void replay(EntryCallback callback) {
        try {
            ObjectInputStream stream = new ObjectInputStream(new FileInputStream(this.file));
            while (true) {
                try {
                    while (true) {
                        callback.nextEntry((Entry)stream.readObject());
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof EOFException) && !(e instanceof StreamCorruptedException)) {
                        if (e instanceof ClassNotFoundException) {
                            System.err.println("Skipping one entry due to a class not found: " + e.getMessage());
                            continue;
                        }
                        e.printStackTrace();
                        continue;
                    }
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("End of File");
        }
    }

    public static void main(String[] args) {
        LogFileReader reader = new LogFileReader("diagnosis.record");
        reader.replay(new EntryCallback(){

            @Override
            public void nextEntry(Entry entry) {
                long time = entry.date;
                String name = (String)CoreKeeper.$(entry.channel).split("\\.").get(-1);
                Object value = entry.value;
                StringBuilder sb = new StringBuilder(100);
                for (String string : entry.additionalInfo.keySet()) {
                    sb.append(":" + string + "=" + entry.additionalInfo.get(string));
                }
                String opts = sb.length() > 0 ? sb.substring(1) : "";
                String output = time + "\t" + name + "\t" + value + "\t" + opts;
                System.out.println(output);
            }
        });
    }
}

