/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.util;

import java.util.ArrayList;
import java.util.Collection;
import net.xeoh.plugins.base.Option;
import net.xeoh.plugins.base.util.OptionHandler;
import net.xeoh.plugins.base.util.VanillaUtil;

public class OptionUtils<T extends Option>
extends VanillaUtil<T[]> {
    public OptionUtils(T ... options) {
        super(options);
    }

    public boolean contains(Class<? extends T> option) {
        for (Option t : (Option[])this.object) {
            if (t == null || !option.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Class<? extends T> ... option) {
        for (Option t : (Option[])this.object) {
            if (t == null) continue;
            for (Class<T> clazz : option) {
                if (!clazz.isAssignableFrom(t.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public <O extends T> O get(Class<? extends O> option, O ... deflt) {
        for (Option t : (Option[])this.object) {
            if (t == null || !option.isAssignableFrom(t.getClass())) continue;
            return (O)t;
        }
        if (deflt.length > 0) {
            return deflt[0];
        }
        return null;
    }

    public <O extends T> Collection<O> getAll(Class<? extends O> option) {
        ArrayList<Option> rval = new ArrayList<Option>();
        for (Option t : (Option[])this.object) {
            if (t == null || !option.isAssignableFrom(t.getClass())) continue;
            rval.add(t);
        }
        return rval;
    }

    public <O extends T> void handle(Class<? extends O> option, OptionHandler<O> handler) {
        for (Option t : (Option[])this.object) {
            if (t == null || !option.isAssignableFrom(t.getClass())) continue;
            handler.handle(t);
        }
    }
}

