/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.locator.locations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;

public class FileClasspathLocation
extends AbstractClassPathLocation {
    public FileClasspathLocation(JARCache cache, String realm, URI location) {
        super(cache, realm, location);
    }

    @Override
    public InputStream getInputStream(String entry) {
        File toplevel = new File(this.location);
        try {
            return new FileInputStream(new File(toplevel.getAbsolutePath() + "/" + entry));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AbstractClassPathLocation.LocationType getType() {
        return AbstractClassPathLocation.LocationType.DIRECTORY;
    }

    @Override
    public Collection<String> listAllEntries() {
        ArrayList<String> rval = new ArrayList<String>();
        File toplevel = new File(this.location);
        try {
            List<File> fileListing = this.getFileListing(toplevel, new ArrayList<String>());
            for (File file : fileListing) {
                if (file.isDirectory()) continue;
                String path = Pattern.quote(toplevel.getAbsolutePath());
                String name = "";
                name = file.getAbsolutePath().replaceAll(path, "");
                name = name.substring(1);
                name = name.replace("\\", "/");
                rval.add(name);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return rval;
    }

    @Override
    public Collection<String> listToplevelClassNames() {
        ArrayList<String> rval = new ArrayList<String>();
        File toplevel = new File(this.location);
        try {
            List<File> fileListing = this.getFileListing(toplevel, new ArrayList<String>());
            for (File file : fileListing) {
                if (!file.getAbsolutePath().endsWith(".class")) continue;
                String path = Pattern.quote(toplevel.getAbsolutePath());
                String name = "";
                name = file.getAbsolutePath().replaceAll(path, "");
                name = name.substring(1);
                name = name.replace("\\", "/");
                if ((name = name.replace("/", ".")).endsWith("class")) {
                    name = name.substring(0, name.length() - 6);
                }
                rval.add(name);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return rval;
    }

    private List<File> getFileListing(File aStartingDir, List<String> visited) throws FileNotFoundException {
        if (aStartingDir == null || aStartingDir.listFiles() == null) {
            return new ArrayList<File>();
        }
        this.logger.fine("Obtaining file listing for: " + aStartingDir);
        String[] ignoreList = new String[]{"/dev/", "/sys/", "/proc/"};
        ArrayList<File> result = new ArrayList<File>();
        for (File file : aStartingDir.listFiles()) {
            boolean skip = false;
            for (String ignore : ignoreList) {
                if (!file.getAbsolutePath().contains(ignore)) continue;
                this.logger.warning("Android hack actve. Ignoring directory containing " + ignore);
                skip = true;
            }
            if (skip) continue;
            result.add(file);
            String canonical = null;
            try {
                canonical = file.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (canonical != null) {
                if (visited.contains(canonical)) continue;
                visited.add(canonical);
            }
            if (!file.isDirectory()) continue;
            List<File> deeperList = this.getFileListing(file, visited);
            result.addAll(deeperList);
        }
        return result;
    }
}

