/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl;

import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.impl.PluginManagerImpl;

public class PluginManagerFactory {
    private PluginManagerFactory() {
    }

    public static PluginManager createPluginManager() {
        return PluginManagerFactory.createPluginManager(new Properties());
    }

    public static PluginManager createPluginManager(Properties initialProperties) {
        if (initialProperties.containsKey("net.xeoh.plugins.base.PluginManager.logging.level")) {
            String level = initialProperties.getProperty("net.xeoh.plugins.base.PluginManager.logging.level");
            PluginManagerFactory.setLogLevel(Level.parse(level));
        }
        Logger.getLogger("javax.jmdns").setLevel(Level.OFF);
        return new PluginManagerImpl(initialProperties);
    }

    private static void setLogLevel(Level level) {
        Handler[] handlers;
        Logger.getLogger("").setLevel(level);
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            handler.setLevel(level);
        }
    }
}

