/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.utils.internal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.jcores.CommonCore;
import net.jcores.cores.CoreObject;
import net.jcores.options.MessageType;

public class StreamUtils {
    public static void doUnzip(InputStream inputStream, String destinationDirectory) throws IOException {
        int BUFFER = 8192;
        ArrayList<String> zipFiles = new ArrayList<String>();
        File unzipDestinationDirectory = new File(destinationDirectory);
        unzipDestinationDirectory.mkdirs();
        ZipInputStream zipFile = (ZipInputStream)(inputStream instanceof ZipInputStream ? inputStream : new ZipInputStream(inputStream));
        ZipEntry nextEntry = zipFile.getNextEntry();
        while (nextEntry != null) {
            String currentEntry = nextEntry.getName();
            File destFile = new File(unzipDestinationDirectory, currentEntry);
            if (currentEntry.endsWith(".zip")) {
                zipFiles.add(destFile.getAbsolutePath());
            }
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            try {
                if (!nextEntry.isDirectory()) {
                    int currentByte;
                    BufferedInputStream is = new BufferedInputStream(zipFile);
                    byte[] data = new byte[8192];
                    FileOutputStream fos = new FileOutputStream(destFile);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 8192);
                    while ((currentByte = is.read(data, 0, 8192)) != -1) {
                        dest.write(data, 0, currentByte);
                    }
                    dest.flush();
                    dest.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            nextEntry = zipFile.getNextEntry();
        }
        zipFile.close();
    }

    public static String readText(CommonCore cc, InputStream is) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            cc.report(MessageType.EXCEPTION, "Error reading from stream " + is);
            return null;
        }
    }

    public static InputStream getInputStream(ZipInputStream zipFile, String path) throws IOException {
        ZipEntry nextEntry = zipFile.getNextEntry();
        while (nextEntry != null) {
            String currentEntry = nextEntry.getName();
            if (!currentEntry.equals(path)) {
                nextEntry = zipFile.getNextEntry();
                continue;
            }
            return new BufferedInputStream(zipFile);
        }
        return null;
    }

    public static List<String> list(ZipInputStream zipFile) throws IOException {
        ArrayList<String> rval = new ArrayList<String>();
        ZipEntry nextEntry = zipFile.getNextEntry();
        while (nextEntry != null) {
            rval.add(nextEntry.getName());
            nextEntry = zipFile.getNextEntry();
        }
        return rval;
    }

    public static String generateHash(InputStream fis, String method) {
        try {
            MessageDigest digest = MessageDigest.getInstance(method);
            byte[] data = new byte[0x100000];
            int avail = fis.available();
            while (avail > 0) {
                avail = Math.min(avail, data.length);
                fis.read(data, 0, avail);
                digest.update(data, 0, avail);
                avail = fis.available();
            }
            byte[] hash = digest.digest();
            StringBuilder sb = new StringBuilder();
            byte[] byArray = hash;
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                String format = String.format("%02x", b);
                sb.append(format);
                ++n2;
            }
            fis.close();
            String hashValue = sb.toString().substring(0, sb.toString().length());
            return hashValue;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveTo(InputStream openStream, File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException e1) {
            return;
        }
        byte[] data = new byte[0x100000];
        int lastRead = 1;
        while (lastRead > 0) {
            try {
                lastRead = openStream.read(data, 0, data.length);
                if (lastRead <= 0) break;
                fos.write(data, 0, lastRead);
            }
            catch (IOException e) {
                lastRead = 0;
            }
        }
        try {
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ByteBuffer getByteData(InputStream x) {
        byte[] globaldata = new byte[0x100000];
        byte[] localdata = new byte[0x100000];
        try {
            int total = 0;
            int lastread = x.read(localdata);
            while (lastread > 0) {
                if (total + lastread > globaldata.length) {
                    byte[] newglobal = new byte[total + 0x100000];
                    System.arraycopy(globaldata, 0, newglobal, 0, total);
                    globaldata = newglobal;
                }
                System.arraycopy(globaldata, total, localdata, 0, lastread);
                total += lastread;
                lastread = x.read(localdata);
            }
            return ByteBuffer.wrap(globaldata, 0, total);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void serializeCore(CoreObject<?> core, FileOutputStream fos) {
        try {
            GZIPOutputStream goz = new GZIPOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(goz);
            oos.writeObject(core);
            oos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> CoreObject<T> deserializeCore(Class<T> type, InputStream fis) {
        try {
            GZIPInputStream gis = new GZIPInputStream(fis);
            ObjectInputStream ois = new ObjectInputStream(gis);
            return (CoreObject)ois.readObject();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

