/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcores.CommonCore;
import net.jcores.CoreKeeper;
import net.jcores.cores.CoreByteBuffer;
import net.jcores.cores.CoreFile;
import net.jcores.cores.CoreObject;
import net.jcores.cores.CoreURI;
import net.jcores.interfaces.functions.F1;
import net.jcores.interfaces.functions.F1Object2Bool;
import net.jcores.options.MessageType;
import net.jcores.options.Option;
import net.jcores.options.OptionRegEx;
import net.jcores.utils.Compound;
import net.jcores.utils.internal.io.StreamUtils;

public class CoreString
extends CoreObject<String> {
    private static final long serialVersionUID = -2412531498060577117L;

    public CoreString(CommonCore supercore, String ... objects) {
        super(supercore, objects);
    }

    public CoreByteBuffer bytes() {
        return new CoreByteBuffer(this.commonCore, this.map(new F1<String, ByteBuffer>(){

            @Override
            public ByteBuffer f(String x) {
                try {
                    byte[] bytes = x.getBytes("UTF-8");
                    return ByteBuffer.wrap(bytes);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
        }, new Option[0]).array(ByteBuffer.class));
    }

    public boolean containssubstr(String substring) {
        int i = 0;
        while (i < this.size()) {
            if (((String[])this.t)[i] != null && ((String[])this.t)[i].contains(substring)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CoreString decode() {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String x) {
                try {
                    return URLDecoder.decode(x, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }, new Option[0]).array(String.class));
    }

    public CoreString encode() {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String x) {
                try {
                    return URLEncoder.encode(x, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }, new Option[0]).array(String.class));
    }

    @Deprecated
    public CoreString exec(Option ... options) {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String x) {
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command(x.split(" "));
                try {
                    Process start = builder.start();
                    start.waitFor();
                    return StreamUtils.readText(CoreString.this.commonCore, start.getInputStream());
                }
                catch (IOException e) {
                    CoreKeeper.$.report(MessageType.EXCEPTION, "Error invoking " + x);
                }
                catch (InterruptedException e) {
                    CoreKeeper.$.report(MessageType.EXCEPTION, "Error waiting for " + x);
                }
                return null;
            }
        }, new Option[0]).array(String.class));
    }

    @Deprecated
    public CoreString exec(final String command, Option ... options) {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String x) {
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                String cmd = x.replaceAll("^(.*)$", command);
                builder.command(cmd.split(" "));
                try {
                    Process start = builder.start();
                    start.waitFor();
                    return StreamUtils.readText(CoreString.this.commonCore, start.getInputStream());
                }
                catch (IOException e) {
                    CoreKeeper.$.report(MessageType.EXCEPTION, "Error invoking " + x);
                }
                catch (InterruptedException e) {
                    CoreKeeper.$.report(MessageType.EXCEPTION, "Error waiting for " + x);
                }
                return null;
            }
        }, new Option[0]).array(String.class));
    }

    public CoreFile file() {
        return new CoreFile(this.commonCore, this.map(new F1<String, File>(){

            @Override
            public File f(String x) {
                return new File(x);
            }
        }, new Option[0]).array(File.class));
    }

    public CoreString filter(String regex, Option ... options) {
        final Pattern p = Pattern.compile(regex);
        return new CoreString(this.commonCore, this.filter(new F1Object2Bool<String>(){

            @Override
            public boolean f(String x) {
                Matcher matcher = p.matcher(x);
                return matcher.matches();
            }
        }, options).array(String.class));
    }

    public Map<String, String> hashmap(final String ... delimeters) {
        final ConcurrentHashMap<String, String> rval = new ConcurrentHashMap<String, String>();
        this.map(new F1<String, Void>(){

            @Override
            public Void f(String x) {
                String[] stringArray;
                if (delimeters.length > 0) {
                    stringArray = delimeters;
                } else {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = ":=";
                    stringArray2[1] = "=";
                    stringArray = stringArray2;
                    stringArray2[2] = ":";
                }
                String[] delims = stringArray;
                Compound<String> best = CoreKeeper.$("token", "", "dist", "2147483647").compound(String.class);
                String[] stringArray3 = delims;
                int n = delims.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray3[n2];
                    int index = x.indexOf(string);
                    if (index >= 0 && index < best.getInt("dist")) {
                        best.put("dist", index);
                        best.put("token", string);
                    }
                    ++n2;
                }
                int dist = best.getInt("dist");
                if (dist < 0) {
                    return null;
                }
                String[] split = x.split(best.getString("token"));
                rval.put(split[0], split[1]);
                return null;
            }
        }, new Option[0]);
        return rval;
    }

    public String join() {
        return this.join("");
    }

    public String join(String joiner) {
        if (this.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int size = this.size();
        int i = 0;
        while (i < size) {
            String string = (String)this.get(i);
            if (string != null) {
                sb.append(string);
                if (i < size - 1) {
                    sb.append(joiner);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public CoreString split(final String splitter) {
        return this.map(new F1<String, List<String>>(){

            @Override
            public List<String> f(String x) {
                return Arrays.asList(x.split(splitter));
            }
        }, new Option[0]).expand(String.class).as(CoreString.class);
    }

    public CoreString print() {
        if (this.size() == 0) {
            return this;
        }
        String[] stringArray = (String[])this.t;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                System.out.println(s);
            }
            ++n2;
        }
        return this;
    }

    public void log() {
        this.log(Level.INFO);
    }

    public void log(final Level level) {
        this.map(new F1<String, Object>(){

            @Override
            public Object f(String x) {
                CoreString.this.commonCore.log(x, level);
                return null;
            }
        }, new Option[0]);
    }

    public CoreString nullempty() {
        return new CoreString(this.commonCore, (String[])this.map(new F1<String, Object>(){

            @Override
            public Object f(String x) {
                return x.length() == 0 ? null : x;
            }
        }, new Option[0]).unsafearray());
    }

    public CoreString replace(String pattern, final String with, Option ... options) {
        int regexOptions = CoreKeeper.$(options).cast(OptionRegEx.class).get(0, new OptionRegEx(0)).getOptions();
        final Pattern p = Pattern.compile(pattern, regexOptions);
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String x) {
                return p.matcher(x).replaceAll(with);
            }
        }, new Option[0]).array(String.class));
    }

    public CoreString trim() {
        return new CoreString(this.commonCore, this.map(new F1<String, String>(){

            @Override
            public String f(String x) {
                return x.trim();
            }
        }, new Option[0]).array(String.class));
    }

    public CoreURI uri() {
        return new CoreURI(this.commonCore, this.map(new F1<String, URI>(){

            @Override
            public URI f(String x) {
                try {
                    return new URI(x);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }, new Option[0]).array(URI.class));
    }
}

