/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcores.CommonCore;
import net.jcores.CoreKeeper;
import net.jcores.cores.Core;
import net.jcores.cores.CoreClass;
import net.jcores.cores.CoreNumber;
import net.jcores.cores.CoreString;
import net.jcores.interfaces.functions.F0;
import net.jcores.interfaces.functions.F1;
import net.jcores.interfaces.functions.F1Object2Bool;
import net.jcores.interfaces.functions.F2DeltaObjects;
import net.jcores.interfaces.functions.F2ReduceObjects;
import net.jcores.interfaces.functions.Fn;
import net.jcores.managers.ManagerDebugGUI;
import net.jcores.managers.ManagerDeveloperFeedback;
import net.jcores.options.MessageType;
import net.jcores.options.Option;
import net.jcores.options.OptionMapType;
import net.jcores.utils.Compound;
import net.jcores.utils.Staple;
import net.jcores.utils.internal.Folder;
import net.jcores.utils.internal.Mapper;
import net.jcores.utils.internal.io.StreamUtils;
import net.jcores.utils.internal.lang.ObjectUtils;

public class CoreObject<T>
extends Core {
    private static final long serialVersionUID = -6436821141631907999L;
    protected final T[] t;

    public CoreObject(CommonCore supercore, Class<?> type, T object) {
        super(supercore);
        if (object != null) {
            this.t = (Object[])Array.newInstance(type, 1);
            this.t[0] = object;
        } else {
            this.t = new Object[0];
        }
    }

    public CoreObject(CommonCore supercore, T ... objects) {
        super(supercore);
        this.t = objects;
    }

    public CoreObject<T> add(CoreObject<T> toAdd) {
        if (this.size() == 0) {
            return toAdd;
        }
        if (toAdd.size() == 0) {
            return this;
        }
        Object[] copy = (Object[])Array.newInstance(this.t.getClass().getComponentType(), this.t.length + toAdd.t.length);
        System.arraycopy(this.t, 0, copy, 0, this.t.length);
        System.arraycopy(toAdd.t, 0, copy, this.t.length, toAdd.t.length);
        return new CoreObject<Object>(this.commonCore, copy);
    }

    public CoreObject<T> add(T ... toAdd) {
        return this.add(new CoreObject<T>(this.commonCore, toAdd));
    }

    public <N> N[] array(Class<N> in) {
        Object[] n = (Object[])Array.newInstance(in, 0);
        if (this.t != null) {
            return Arrays.copyOf(this.t, this.t.length, n.getClass());
        }
        return (Object[])Array.newInstance(in, 0);
    }

    public <C extends Core> C as(Class<C> clazz) {
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            Constructor<?> constructor = null;
            Constructor<?>[] constructorArray = constructors;
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> c = constructorArray[n2];
                if (c.getParameterTypes().length == 2 && c.getParameterTypes()[0].equals(CommonCore.class)) {
                    if (constructor != null) {
                        System.err.println("There should only be one constructor per core! And here comes your exception ... ;-)");
                    }
                    constructor = c;
                }
                ++n2;
            }
            Object[] newT = null;
            Class<?> requestedType = null;
            try {
                requestedType = constructor.getParameterTypes()[1];
                newT = Arrays.copyOf(this.t, this.size(), requestedType);
            }
            catch (ArrayStoreException e) {
                this.commonCore.report(MessageType.EXCEPTION, "Unable to convert our array " + this.t + " to the requested type " + requestedType + ". Returning empty core.");
                newT = (Object[])Array.newInstance(requestedType.getComponentType(), 0);
            }
            return (C)((Core)constructor.newInstance(this.commonCore, newT));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            this.commonCore.report(MessageType.EXCEPTION, "No constructor found for " + clazz);
            System.err.println("No suitable constructor found!");
        }
        return null;
    }

    public CoreObject<Object> call(final String string, final Object ... params) {
        int len = params == null ? 0 : params.length;
        final Class[] types = new Class[len];
        int i = 0;
        while (i < len) {
            types[i] = params[i].getClass();
            ++i;
        }
        return new CoreObject<Object>(this.commonCore, this.map(new F1<T, Object>(){

            @Override
            public Object f(T x) {
                try {
                    Method method = x.getClass().getMethod(string, types);
                    return method.invoke(x, params);
                }
                catch (SecurityException e) {
                    CoreObject.this.commonCore.report(MessageType.EXCEPTION, "SecurityException for " + x + " (method was " + string + ")");
                }
                catch (NoSuchMethodException e) {
                    CoreObject.this.commonCore.report(MessageType.EXCEPTION, "NoSuchMethodException for " + x + " (method was " + string + ")");
                }
                catch (IllegalArgumentException e) {
                    CoreObject.this.commonCore.report(MessageType.EXCEPTION, "IllegalArgumentException for " + x + " (method was " + string + ")");
                }
                catch (IllegalAccessException e) {
                    CoreObject.this.commonCore.report(MessageType.EXCEPTION, "IllegalAccessException for " + x + " (method was " + string + ")");
                }
                catch (InvocationTargetException e) {
                    CoreObject.this.commonCore.report(MessageType.EXCEPTION, "InvocationTargetException for " + x + " (method was " + string + ")");
                }
                return null;
            }
        }, new Option[0]).array(Object.class));
    }

    public <N> CoreObject<N> cast(final Class<N> target) {
        return this.map(new F1<T, N>(){

            @Override
            public N f(T x) {
                if (target.isAssignableFrom(x.getClass())) {
                    return x;
                }
                return null;
            }
        }, new OptionMapType(target));
    }

    public CoreClass<T> clazz() {
        return new CoreClass(this.commonCore, this.map(new F1<T, Class<T>>(){

            @Override
            public Class<T> f(T x) {
                return x.getClass();
            }
        }, new Option[0]).array(Class.class));
    }

    public CoreObject<T> compact() {
        if (this.size() == 0) {
            return this;
        }
        T[] tmp = Arrays.copyOf(this.t, this.t.length);
        int dst = 0;
        int i = 0;
        while (i < this.t.length) {
            if (this.t[i] != null) {
                tmp[dst++] = this.t[i];
            }
            ++i;
        }
        return new CoreObject<T>(this.commonCore, Arrays.copyOf(tmp, dst));
    }

    public Compound<Object> compound() {
        return Compound.create(this.t);
    }

    public <C> Compound<C> compound(Class<C> clazz) {
        return Compound.create(this.t);
    }

    public boolean contains(T object) {
        int i = 0;
        while (i < this.size()) {
            if (this.t[i] != null && this.t[i].equals(object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CoreObject<T> debug() {
        System.out.println(this.fingerprint(false));
        ManagerDebugGUI debugGUI = this.commonCore.manager(ManagerDebugGUI.class);
        return this;
    }

    public <R> CoreObject<R> delta(final F2DeltaObjects<T, R> delta, Option ... options) {
        final int size = this.size();
        Mapper mapper = new Mapper<T, R>(this, options){

            @Override
            public void handle(int i) {
                if (i == size - 1) {
                    return;
                }
                Object[] a = (Object[])this.returnArray.get();
                Object ii = CoreObject.this.t[i];
                Object jj = CoreObject.this.t[i + 1];
                if (ii == null || jj == null) {
                    return;
                }
                Object out = delta.f(ii, jj);
                if (out == null) {
                    return;
                }
                if (a == null) {
                    a = this.updateReturnArray((Object[])Array.newInstance(out.getClass(), size));
                }
                a[i] = out;
            }
        };
        this.map(mapper, options);
        return new CoreObject(this.commonCore, mapper.getFinalReturnArray());
    }

    public <X> X each(Class<X> c) {
        if (c == null || !c.isInterface()) {
            System.err.println("You must pass an interface.");
            return null;
        }
        final CoreObject<X> filtered = this.cast(c);
        return (X)ObjectUtils.getProxy(new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                filtered.map(new F1<X, Object>(){

                    @Override
                    public Object f(X x) {
                        try {
                            method.invoke(x, args);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                }, new Option[0]);
                return null;
            }
        }, c);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CoreObject)) {
            return false;
        }
        CoreObject other = (CoreObject)obj;
        return Arrays.deepEquals(this.t, other.t);
    }

    public <N> CoreObject<N> expand(Class<N> class1) {
        int length = 0;
        if (this.size() == 0) {
            return new CoreObject<Object>(this.commonCore, class1, null);
        }
        T[] TArray = this.t;
        int n = this.t.length;
        int n2 = 0;
        while (n2 < n) {
            T x = TArray[n2];
            if (x != null) {
                if (x instanceof Collection) {
                    length += ((Collection)x).size();
                } else if (x instanceof CoreObject) {
                    length += ((CoreObject)x).size();
                } else {
                    try {
                        length += Array.getLength(x);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ++length;
                    }
                }
            }
            ++n2;
        }
        Object[] n3 = (Object[])Array.newInstance(class1, length);
        int offset = 0;
        T[] TArray2 = this.t;
        int n4 = this.t.length;
        int n5 = 0;
        while (n5 < n4) {
            block19: {
                T x = TArray2[n5];
                if (x != null) {
                    if (x instanceof Collection) {
                        Object[] array = ((Collection)x).toArray();
                        System.arraycopy(array, 0, n3, offset, array.length);
                        offset += array.length;
                    } else if (x instanceof CoreObject) {
                        Object[] array = ((CoreObject)x).array(Object.class);
                        System.arraycopy(array, 0, n3, offset, array.length);
                        offset += array.length;
                    } else {
                        try {
                            int size = Array.getLength(x);
                            System.arraycopy(x, 0, n3, offset, size);
                            offset += size;
                            break block19;
                        }
                        catch (IndexOutOfBoundsException e) {
                            e.printStackTrace();
                        }
                        catch (ArrayStoreException arrayStoreException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        Array.set(n3, offset++, x);
                    }
                }
            }
            ++n5;
        }
        return new CoreObject<Object>(this.commonCore, n3);
    }

    public void featurerequest(String functionName) {
        this.commonCore.manager(ManagerDeveloperFeedback.class).featurerequest(functionName, this.fingerprint(true));
    }

    public CoreObject<T> fill(T fillValue) {
        if (this.size() == 0) {
            return this;
        }
        T[] copy = Arrays.copyOf(this.t, this.size());
        int i = 0;
        while (i < copy.length) {
            copy[i] = copy[i] == null ? fillValue : copy[i];
            ++i;
        }
        return new CoreObject<T>(this.commonCore, copy);
    }

    public CoreObject<T> filter(final F1Object2Bool<T> f, Option ... options) {
        final boolean invert = CoreKeeper.$(options).contains(Option.INVERT_SELECTION);
        CoreObject rval = this.map(new F1<T, T>(){

            @Override
            public T f(T x) {
                boolean result = f.f(x);
                if (!invert && result || invert == !result) {
                    return x;
                }
                return null;
            }
        }, new Option[0]);
        return rval.compact();
    }

    public CoreObject<T> filter(String regex, Option ... options) {
        final Pattern p = Pattern.compile(regex);
        return this.filter(new F1Object2Bool<T>(){

            @Override
            public boolean f(T x) {
                Matcher matcher = p.matcher(x.toString());
                return matcher.matches();
            }
        }, options);
    }

    protected String fingerprint(boolean detailed) {
        StringBuilder sb = new StringBuilder();
        sb.append("@(");
        sb.append(this.getClass().getSimpleName());
        sb.append("; outerSize:");
        sb.append(this.size());
        sb.append("; innerSize:");
        if (this.t != null) {
            Object first = null;
            int ctr = 0;
            int i = 0;
            while (i < this.t.length) {
                if (this.t[i] != null) {
                    ++ctr;
                    if (first == null) {
                        first = this.t[i];
                    }
                }
                ++i;
            }
            sb.append(ctr);
            if (first != null && detailed) {
                sb.append("; firstElement:");
                sb.append(first.getClass().getSimpleName());
            }
        } else {
            sb.append("null");
        }
        if (this.t != null && this.t.length <= 16) {
            sb.append("; fingerprint:");
            int i = 0;
            while (i < this.t.length) {
                if (this.t[i] != null) {
                    sb.append(this.t[i].getClass().getSimpleName().charAt(0));
                } else {
                    sb.append(".");
                }
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public CoreObject<T> fold(final F2ReduceObjects<T> f, Option ... options) {
        if (this.size() <= 1) {
            return this;
        }
        final AtomicReferenceArray<T> array = new AtomicReferenceArray<T>(this.t);
        Folder folder = new Folder<T>(this){

            @Override
            public void handle(int i, int j, int destination) {
                Object ii = array.get(i);
                Object jj = array.get(j);
                if (ii == null && jj == null) {
                    return;
                }
                if (ii == null && jj != null) {
                    array.set(destination, jj);
                    return;
                }
                if (ii != null && jj == null) {
                    array.set(destination, ii);
                    return;
                }
                array.set(destination, f.f(ii, jj));
            }
        };
        this.fold(folder, options);
        T[] target = Arrays.copyOf(this.t, 1);
        target[0] = array.get(0);
        return new CoreObject<T>(this.commonCore, target);
    }

    public <R> CoreObject<R> forEach(F1<T, R> f, Option ... _options) {
        Mapper mapper = this.mapper(f, _options);
        int i = 0;
        while (i < this.size()) {
            mapper.handle(i);
            ++i;
        }
        return new CoreObject(this.commonCore, mapper.getFinalReturnArray());
    }

    public <R> CoreObject<R> forEach(Fn<T, R> f, int n) {
        if (this.size() == 0) {
            return new CoreObject<Object>(this.commonCore, null, null);
        }
        Object[] rval = null;
        T[] slice = Arrays.copyOf(this.t, n);
        int ptr = 0;
        int tptr = 0;
        int i = 0;
        while (i < this.size()) {
            T e = this.t[i];
            if (e != null) {
                slice[ptr++] = e;
                if (ptr >= n) {
                    R result = f.f(slice);
                    if (rval == null && result != null) {
                        rval = (Object[])Array.newInstance(result.getClass(), this.size() / n);
                    }
                    if (rval != null) {
                        rval[tptr] = result;
                    }
                    ++tptr;
                    ptr = 0;
                }
            }
            ++i;
        }
        return new CoreObject<Object>(this.commonCore, rval);
    }

    public T get(double percent, T dflt) {
        if (Double.isNaN(percent)) {
            return dflt;
        }
        if (percent < 0.0) {
            return dflt;
        }
        if (percent > 1.0) {
            return dflt;
        }
        if (this.size() == 0) {
            return dflt;
        }
        int offset = (int)(percent * (double)this.size());
        if (offset >= this.t.length) {
            return dflt;
        }
        return this.t[offset];
    }

    public T get(double percent) {
        return this.get(percent, null);
    }

    public <X extends T> X get(Class<X> request, X dflt) {
        int i = 0;
        while (i < this.size()) {
            if (this.t[i] != null && request.isAssignableFrom(this.t[i].getClass())) {
                return (X)this.t[i];
            }
            ++i;
        }
        return dflt;
    }

    public T get(int i) {
        int offset = this.indexToOffset(i);
        if (this.t == null || offset < 0) {
            return null;
        }
        return this.t[offset];
    }

    public T get(int i, T dflt) {
        int rval = this.get((T)i);
        return rval == null ? dflt : (T)rval;
    }

    public T get(T dflt) {
        return this.get(0, dflt);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.t);
    }

    public boolean hasAll() {
        if (this.t == null) {
            return false;
        }
        int i = 0;
        while (i < this.t.length) {
            if (this.t[i] == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasAny() {
        if (this.t == null) {
            return false;
        }
        int i = 0;
        while (i < this.t.length) {
            if (this.t[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CoreObject<T> ifAll(F0 f0) {
        if (this.hasAll()) {
            f0.f();
        }
        return this;
    }

    public CoreNumber index(T ... objects) {
        if (objects == null) {
            return new CoreNumber(this.commonCore, new Number[0]);
        }
        Number[] indices = new Integer[objects.length];
        int i = 0;
        while (i < objects.length) {
            T obj = objects[i];
            if (obj != null) {
                int j = 0;
                while (j < this.size()) {
                    if (obj.equals(this.get((T)j))) {
                        indices[i] = j;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return new CoreNumber(this.commonCore, indices);
    }

    public CoreObject<T> intersect(CoreObject<T> other) {
        if (this.size() == 0) {
            return this;
        }
        if (other.size() == 0) {
            return other;
        }
        T[] copy = Arrays.copyOf(this.t, this.size());
        int i = 0;
        while (i < copy.length) {
            T element = copy[i];
            if (element != null) {
                boolean found = false;
                int j = 0;
                while (j < other.size()) {
                    int x = other.get(j);
                    if (x != null && x.equals(element)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    copy[i] = null;
                }
            }
            ++i;
        }
        return new CoreObject<T>(this.commonCore, copy).compact();
    }

    public CoreObject<T> intersect(T ... other) {
        return this.intersect(new CoreObject<T>(this.commonCore, other));
    }

    public List<T> list() {
        if (this.t == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(Arrays.asList(this.t));
    }

    public <R> CoreObject<R> map(F1<T, R> f, Option ... _options) {
        Mapper mapper = this.mapper(f, _options);
        this.map(mapper, _options);
        return new CoreObject(this.commonCore, mapper.getFinalReturnArray());
    }

    public CoreObject<T> print() {
        if (this.size() == 0) {
            return this;
        }
        T[] TArray = this.t;
        int n = this.t.length;
        int n2 = 0;
        while (n2 < n) {
            T s = TArray[n2];
            if (s != null) {
                System.out.println(s);
            }
            ++n2;
        }
        return this;
    }

    public T random() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.t[this.commonCore.random().nextInt(size)];
    }

    public CoreObject<T> random(double percent) {
        double p = Math.max(Math.min(1.0, percent), 0.0);
        return this.random((int)(p * (double)this.size()));
    }

    public CoreObject<T> random(int newSize) {
        int size = this.size();
        if (size == 0) {
            return this;
        }
        T[] copyOf = Arrays.copyOf(this.t, size);
        int i = copyOf.length - 1;
        while (i >= 1) {
            int j = this.commonCore.random().nextInt(i + 1);
            T x = copyOf[j];
            copyOf[j] = copyOf[i];
            copyOf[i] = x;
            --i;
        }
        return new CoreObject<T>(this.commonCore, Arrays.copyOfRange(copyOf, 0, newSize));
    }

    public CoreObject<T> reduce(F2ReduceObjects<T> f, Option ... options) {
        Object stack = null;
        int i = 0;
        while (i < this.size()) {
            T current = this.t[i];
            if (current != null) {
                stack = stack == null ? current : f.f(stack, current);
            }
            ++i;
        }
        Class<?> type = stack != null ? stack.getClass() : null;
        return new CoreObject<Object>(this.commonCore, type, stack);
    }

    public CoreObject<T> serialize(String path, Option ... options) {
        try {
            StreamUtils.serializeCore(this, new FileOutputStream(new File(path)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public int size() {
        if (this.t == null) {
            return 0;
        }
        return this.t.length;
    }

    public CoreObject<T> slice(int start, int length) {
        int l;
        if (this.size() == 0) {
            return this;
        }
        int i = this.indexToOffset(start);
        int n = l = length > 0 ? length : this.indexToOffset(length) - i + 1;
        if (i < 0 || i >= this.size()) {
            this.commonCore.report(MessageType.MISUSE, "slice() - converted parameter start(" + start + " -> " + i + ") is outside bounds.");
            return new CoreObject<T>(this.commonCore, Arrays.copyOfRange(this.t, 0, 0));
        }
        if (l < 0 || l > this.size()) {
            this.commonCore.report(MessageType.MISUSE, "slice() - converted parameter length(" + length + " -> " + l + ") is outside bounds.");
            return new CoreObject<T>(this.commonCore, Arrays.copyOfRange(this.t, 0, 0));
        }
        return new CoreObject<T>(this.commonCore, Arrays.copyOfRange(this.t, i, i + l));
    }

    public CoreObject<T> sort(Comparator<T> c) {
        if (this.size() == 0) {
            return this;
        }
        T[] copyOf = Arrays.copyOf(this.t, this.size());
        Arrays.sort(copyOf, c);
        return new CoreObject<T>(this.commonCore, copyOf);
    }

    public CoreObject<T> sort() {
        if (this.size() == 0) {
            return this;
        }
        Object[] copyOf = Arrays.copyOf(this.t, this.size());
        try {
            Arrays.sort(copyOf);
        }
        catch (ClassCastException e) {
            this.commonCore.report(MessageType.EXCEPTION, "Unable to sort core, elements not comparable: " + this.fingerprint(true));
            return this;
        }
        return new CoreObject<Object>(this.commonCore, copyOf);
    }

    public Staple<T> staple(T neutralElement, F2ReduceObjects<T> sumAndNext) {
        int size = this.size();
        if (size == 0) {
            return new Staple<T>(neutralElement, 1);
        }
        int count = 0;
        T sum = neutralElement;
        int i = 0;
        while (i < size) {
            if (this.t[i] != null) {
                sum = sumAndNext.f(sum, this.t[i]);
                ++count;
            }
            ++i;
        }
        return new Staple<T>(sum, count);
    }

    public CoreString string() {
        return this.map(new F1<T, String>(){

            @Override
            public String f(T x) {
                return x.toString();
            }
        }, new Option[0]).as(CoreString.class);
    }

    public CoreObject<T> subtract(CoreObject<T> toSubtract) {
        if (this.size() == 0 || toSubtract.size() == 0) {
            return this;
        }
        T[] copy = Arrays.copyOf(this.t, this.size());
        int i = 0;
        while (i < toSubtract.size()) {
            int element = toSubtract.get(i);
            if (element != null) {
                int j = 0;
                while (j < copy.length) {
                    T our = copy[j];
                    if (our != null && our.equals(element)) {
                        copy[j] = null;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return new CoreObject<T>(this.commonCore, copy);
    }

    public CoreObject<T> subtract(T ... toSubtract) {
        return this.subtract(new CoreObject<T>(this.commonCore, toSubtract));
    }

    public CoreObject<T> unique() {
        if (this.size() == 0) {
            return this;
        }
        T[] copy = Arrays.copyOf(this.t, this.size());
        int i = 1;
        while (i < copy.length) {
            if (copy[i] != null) {
                int j = 0;
                while (j < i) {
                    if (copy[i].equals(copy[j])) {
                        copy[i] = null;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return new CoreObject<T>(this.commonCore, copy).compact();
    }

    public T[] unsafearray() {
        if (this.t == null) {
            return null;
        }
        return (Object[])this.t.clone();
    }

    protected final int indexToOffset(int index) {
        int size = this.size();
        if (index >= size) {
            return -1;
        }
        if (index < 0) {
            if (-index > size) {
                return -1;
            }
            return size + index;
        }
        return index;
    }

    protected final <R> Mapper mapper(final F1<T, R> f, Option ... options) {
        return new Mapper<T, R>(this, options){

            @Override
            public void handle(int i) {
                Object out;
                Object[] a = (Object[])this.returnArray.get();
                Object in = CoreObject.this.t[i];
                if (in == null) {
                    return;
                }
                if (this.options.indexer != null) {
                    this.options.indexer.i(i);
                }
                if ((out = f.f(in)) == null) {
                    return;
                }
                if (a == null) {
                    a = this.updateReturnArray((Object[])Array.newInstance(out.getClass(), this.core.size()));
                }
                a[i] = out;
            }
        };
    }
}

