/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import net.jcores.CommonCore;
import net.jcores.CoreKeeper;
import net.jcores.cores.CoreAudioInputStream;
import net.jcores.cores.CoreBufferedImage;
import net.jcores.cores.CoreByteBuffer;
import net.jcores.cores.CoreInputStream;
import net.jcores.cores.CoreNumber;
import net.jcores.cores.CoreObject;
import net.jcores.cores.CoreString;
import net.jcores.cores.CoreURI;
import net.jcores.interfaces.functions.F1;
import net.jcores.interfaces.functions.F1Object2Bool;
import net.jcores.options.MessageType;
import net.jcores.options.Option;
import net.jcores.utils.internal.io.FileUtils;
import net.jcores.utils.internal.io.StreamUtils;
import net.jcores.utils.internal.sound.SoundUtils;

public class CoreFile
extends CoreObject<File> {
    private static final long serialVersionUID = -8743359735096052185L;

    public CoreFile(CommonCore supercore, File ... files) {
        super(supercore, files);
    }

    public CoreFile append(Object object) {
        if (object == null) {
            return this;
        }
        final String string = object.toString();
        this.map(new F1<File, Object>(){

            @Override
            public Object f(File x) {
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(x, true)), "UTF-8"));
                    printWriter.append(string);
                    printWriter.flush();
                    printWriter.close();
                }
                catch (FileNotFoundException e) {
                    CoreFile.this.commonCore.report(MessageType.EXCEPTION, e.getLocalizedMessage());
                }
                catch (UnsupportedEncodingException e) {
                    CoreFile.this.commonCore.report(MessageType.EXCEPTION, e.getLocalizedMessage());
                }
                return null;
            }
        }, new Option[0]);
        return this;
    }

    public CoreAudioInputStream audio() {
        return new CoreAudioInputStream(this.commonCore, this.map(new F1<File, AudioInputStream>(){

            @Override
            public AudioInputStream f(File x) {
                return SoundUtils.getStream(x);
            }
        }, new Option[0]).array(AudioInputStream.class));
    }

    public CoreFile copy(String destination) {
        if (destination == null) {
            this.commonCore.report(MessageType.MISUSE, "Destination null for copy().");
            return this;
        }
        final File dest = new File(destination);
        return new CoreFile(this.commonCore, this.map(new F1<File, File[]>(){

            @Override
            public File[] f(File x) {
                return FileUtils.copy(CoreFile.this.commonCore, x, dest);
            }
        }, new Option[0]).expand(File.class).array(File.class));
    }

    public CoreByteBuffer data() {
        return new CoreByteBuffer(this.commonCore, this.map(new F1<File, ByteBuffer>(){

            @Override
            public ByteBuffer f(File x) {
                ByteBuffer buffer;
                FileChannel channel;
                block4: {
                    channel = new FileInputStream(x).getChannel();
                    long size = channel.size();
                    buffer = ByteBuffer.allocate((int)size);
                    int read = channel.read(buffer);
                    if ((long)read == size) break block4;
                    CoreFile.this.commonCore.report(MessageType.EXCEPTION, "Error reading data() from " + x + ". Size mismatch (" + read + " != " + size + ")");
                    return null;
                }
                try {
                    channel.close();
                    return buffer;
                }
                catch (FileNotFoundException e) {
                    CoreFile.this.commonCore.report(MessageType.EXCEPTION, "Error reading data() from " + x + ". File not found!");
                    return null;
                }
                catch (IOException e) {
                    CoreFile.this.commonCore.report(MessageType.EXCEPTION, "Error reading data() from " + x + ". IOException!");
                    return null;
                }
            }
        }, new Option[0]).array(ByteBuffer.class));
    }

    public CoreFile delete() {
        this.map(new F1<File, Void>(){

            @Override
            public Void f(File x) {
                int lastSize = Integer.MAX_VALUE;
                List list = CoreKeeper.$(x).dir(Option.LIST_DIRECTORIES).list();
                while (list.size() < lastSize) {
                    lastSize = list.size();
                    for (File file : list) {
                        file.delete();
                    }
                    list = CoreKeeper.$(x).dir(Option.LIST_DIRECTORIES).list();
                }
                x.delete();
                return null;
            }
        }, new Option[0]);
        return this;
    }

    public <T> CoreObject<T> deserialize(Class<T> type, Option ... options) {
        if (this.size() > 1) {
            this.commonCore.report(MessageType.MISUSE, "deserialize() should not be used on cores with more than one class!");
        }
        try {
            CoreObject<T> core = StreamUtils.deserializeCore(type, new FileInputStream((File)this.get(false)));
            if (core != null) {
                core.commonCore = this.commonCore;
                return core;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return new CoreObject<Object>(this.commonCore, type, null);
    }

    public CoreFile dir(Option ... options) {
        final boolean listDirs = CoreKeeper.$(options).contains(Option.LIST_DIRECTORIES);
        return this.map(new F1<File, File[]>(){

            @Override
            public File[] f(File x) {
                return FileUtils.dir(x, listDirs);
            }
        }, new Option[0]).expand(File.class).unique().as(CoreFile.class);
    }

    public CoreNumber filesize() {
        return new CoreNumber(this.commonCore, this.map(new F1<File, Long>(){

            @Override
            public Long f(File x) {
                return x.length();
            }
        }, new Option[0]).array(Long.class));
    }

    public CoreFile filter(String regex, Option ... options) {
        final Pattern p = Pattern.compile(regex);
        return new CoreFile(this.commonCore, this.filter(new F1Object2Bool<File>(){

            @Override
            public boolean f(File x) {
                Matcher matcher = p.matcher(x.getAbsolutePath());
                return matcher.matches();
            }
        }, options).array(File.class));
    }

    public CoreBufferedImage images() {
        return new CoreBufferedImage(this.commonCore, this.map(new F1<File, BufferedImage>(){

            @Override
            public BufferedImage f(File x) {
                try {
                    return ImageIO.read(x);
                }
                catch (IOException e) {
                    CoreFile.this.commonCore.report(MessageType.EXCEPTION, "Error loading image " + x);
                    return null;
                }
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreInputStream input() {
        return new CoreInputStream(this.commonCore, this.map(new F1<File, InputStream>(){

            @Override
            public InputStream f(File x) {
                try {
                    return new BufferedInputStream(new FileInputStream(x));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }, new Option[0]).array(InputStream.class));
    }

    public CoreString text() {
        return new CoreString(this.commonCore, this.map(new F1<File, String>(){

            @Override
            public String f(File x) {
                return FileUtils.readText(CoreFile.this.commonCore, x);
            }
        }, new Option[0]).array(String.class));
    }

    public CoreURI uri() {
        return new CoreURI(this.commonCore, this.map(new F1<File, URI>(){

            @Override
            public URI f(File x) {
                return x.toURI();
            }
        }, new Option[0]).array(URI.class));
    }

    public CoreFile zip(String target, Option ... options) {
        FileUtils.zipFiles(new File(target), (File[])this.t);
        return this;
    }
}

