/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.cores;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.jcores.CommonCore;
import net.jcores.cores.CoreObject;
import net.jcores.interfaces.functions.F1;
import net.jcores.options.MessageType;
import net.jcores.options.Option;

public class CoreBufferedImage
extends CoreObject<BufferedImage> {
    private static final long serialVersionUID = -9069210371713045372L;

    public CoreBufferedImage(CommonCore supercore, BufferedImage ... objects) {
        super(supercore, objects);
    }

    public CoreBufferedImage copy() {
        return new CoreBufferedImage(this.commonCore, this.map(new F1<BufferedImage, BufferedImage>(){

            @Override
            public BufferedImage f(BufferedImage bi) {
                ColorModel cm = bi.getColorModel();
                boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
                WritableRaster raster = bi.copyData(null);
                return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreBufferedImage scale(final float factor) {
        return new CoreBufferedImage(this.commonCore, this.map(new F1<BufferedImage, BufferedImage>(){

            @Override
            public BufferedImage f(BufferedImage bi) {
                AffineTransform af = new AffineTransform();
                af.scale(factor, factor);
                AffineTransformOp operation = new AffineTransformOp(af, 2);
                return operation.filter(bi, null);
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreBufferedImage scale(final int width, final int height) {
        if (width == 0 && height == 0) {
            return this;
        }
        return new CoreBufferedImage(this.commonCore, this.map(new F1<BufferedImage, BufferedImage>(){

            @Override
            public BufferedImage f(BufferedImage bi) {
                AffineTransform af = new AffineTransform();
                float w = bi.getWidth();
                float h = bi.getHeight();
                if (width <= 0) {
                    h = height;
                    w = (float)height / h * w;
                }
                if (height <= 0) {
                    h = (float)width / w * h;
                    w = width;
                }
                if (width > 0 && height > 0) {
                    h = height;
                    w = width;
                }
                af.scale(w / (float)bi.getWidth(), h / (float)bi.getHeight());
                AffineTransformOp operation = new AffineTransformOp(af, 2);
                return operation.filter(bi, null);
            }
        }, new Option[0]).array(BufferedImage.class));
    }

    public CoreBufferedImage write(String file) {
        if (file == null) {
            return this;
        }
        if (this.size() != 1) {
            this.commonCore.report(MessageType.MISUSE, "CoreBufferedImage.write() needs exactly one image to write, at the moment.");
        }
        String type = "png";
        type = file.toLowerCase().endsWith(".gif") ? "GIF" : type;
        type = file.toLowerCase().endsWith(".jpg") ? "JPG" : type;
        type = file.toLowerCase().endsWith(".jpeg") ? "JPG" : type;
        type = file.toLowerCase().endsWith(".bmp") ? "BMP" : type;
        type = file.toLowerCase().endsWith(".wbmp") ? "WBMP" : type;
        try {
            ImageIO.write((RenderedImage)this.get(false), type, new File(file));
        }
        catch (IOException e) {
            this.commonCore.report(MessageType.EXCEPTION, "Error writing image to file " + file);
        }
        return this;
    }
}

